# Metrics

This page explains how to use the Prometheus metrics generated by GoBGP.

## Prerequisites

Assume you finished [Getting Started](getting-started.md).

## Contents

- [Scraping the metrics](#scraping-the-metrics)
- [Exported metrics](#exported-metrics)
- [Label values](#label-values)
- [Grafana dashboard](#grafana-dashboard)

## Scraping the metrics

GoBGP exposes the metric endpoint and the pprof endpoint using the same startup flag: `--pprof-host`. By default, it listens locally on port `6060`.  
The path on which the Prometheus metrics are exposed by default is `/metrics` and can be overriden using `--metrics-path`. Ensure `--pprof-disable` is not specified, or it will disable both `pprof` and
the metric endpoint, unless an override for the path is specified through `--metrics-path` (in that case, metrics will be exposed anyways).  

Manually scrape the metrics to verify your setup is working:

```bash
curl -s localhost:6060/metrics

# HELP bgp_routes_received Number of routes received from peer
# TYPE bgp_routes_received gauge
bgp_routes_received{peer="100.109.96.78",route_family="l2vpn-evpn"} 3
bgp_routes_received{peer="100.125.49.61",route_family="l2vpn-evpn"} 3
bgp_routes_received{peer="100.67.112.61",route_family="l2vpn-evpn"} 3
bgp_routes_received{peer="100.75.128.54",route_family="l2vpn-evpn"} 2
# HELP bgp_sent_discarded_total Number of discarded BGP messages to peer
# TYPE bgp_sent_discarded_total counter
bgp_sent_discarded_total{peer="100.109.96.78"} 0
bgp_sent_discarded_total{peer="100.125.49.61"} 0
bgp_sent_discarded_total{peer="100.67.112.61"} 0
bgp_sent_discarded_total{peer="100.75.128.54"} 0
# HELP bgp_sent_keepalive_total Number of sent BGP KEEPALIVE messages from peer
# TYPE bgp_sent_keepalive_total counter
bgp_sent_keepalive_total{peer="100.109.96.78"} 536
bgp_sent_keepalive_total{peer="100.125.49.61"} 536
bgp_sent_keepalive_total{peer="100.67.112.61"} 536
bgp_sent_keepalive_total{peer="100.75.128.54"} 536
# HELP bgp_sent_message_total Number of sent BGP messages from peer
# TYPE bgp_sent_message_total counter
bgp_sent_message_total{peer="100.109.96.78"} 545
bgp_sent_message_total{peer="100.125.49.61"} 545
bgp_sent_message_total{peer="100.67.112.61"} 545
bgp_sent_message_total{peer="100.75.128.54"} 546
...
```

## Exported metrics

The metrics are all prefixed with the `bgp` Prometheus namespace.  

| **Metric**                         | **Description**                                                              | **Labels**                             |
| ---------------------------------- | ---------------------------------------------------------------------------- |----------------------------------------|
| bgp_peer_state                     | State of the BGP session with peer and its administrative state              | `peer`, `session_state`, `admin_state` |
| bgp_peer_asn                       | What is the AS number of the peer and its router ID                          | `peer`, `router_id`                    |
| bgp_peer_local_asn                 | What is the AS number presented to the peer by this router and its ID        | `peer`, `router_id`                    |
| bgp_peer_flop_count                | Number of flops with the peer                                                | `peer`                                 |
| bgp_peer_out_queue_count           | Length of the outgoing message queue                                         | `peer`                                 |
| bgp_peer_password_set              | Whether the GoBGP peer has been configured (1) for authentication or not (0) | `peer`                                 |
| bgp_peer_remove_private_as         | Do we remove private ASNs from the paths sent to the peer                    | `peer`                                 |
| bgp_peer_send_community            | BGP community with the peer                                                  | `peer`                                 |
| bgp_peer_type                      | Type of the BGP peer, internal (0) or external (1)                           | `peer`                                 |
| bgp_peer_uptime                    | For how long the peer has been in its current state                          | `peer`                                 |
| bgp_routes_accepted                | Number of routes accepted from peer                                          | `peer`, `route_family`                 |
| bgp_routes_advertised              | Number of routes advertised to peer                                          | `peer`, `route_family`                 |
| bgp_routes_received                | Number of routes received from peer                                          | `peer`, `route_family`                 |
| bgp_sent_discarded_total           | Number of discarded BGP messages to peer                                     | `peer`                                 |
| bgp_sent_keepalive_total           | Number of sent BGP KEEPALIVE messages from peer                              | `peer`                                 |
| bgp_sent_message_total             | Number of sent BGP messages from peer                                        | `peer`                                 |
| bgp_sent_notification_total        | Number of sent BGP NOTIFICATION messages from peer                           | `peer`                                 |
| bgp_sent_open_total                | Number of sent BGP OPEN messages from peer                                   | `peer`                                 |
| bgp_sent_refresh_total             | Number of sent BGP REFRESH messages from peer                                | `peer`                                 |
| bgp_sent_update_total              | Number of sent BGP UPDATE messages from peer                                 | `peer`                                 |
| bgp_sent_withdraw_prefix_total     | Number of sent BGP WITHDRAW-PREFIX messages from peer                        | `peer`                                 |
| bgp_sent_withdraw_update_total     | Number of sent BGP WITHDRAW-UPDATE messages from peer                        | `peer`                                 |
| bgp_received_discarded_total       | Number of discarded BGP messages from peer                                   | `peer`                                 |
| bgp_received_keepalive_total       | Number of received BGP KEEPALIVE messages from peer                          | `peer`                                 |
| bgp_received_message_total         | Number of received BGP messages from peer                                    | `peer`                                 |
| bgp_received_notification_total    | Number of received BGP NOTIFICATION messages from peer                       | `peer`                                 |
| bgp_received_open_total            | Number of received BGP OPEN messages from peer                               | `peer`                                 |
| bgp_received_refresh_total         | Number of received BGP REFRESH messages from peer                            | `peer`                                 |
| bgp_received_update_total          | Number of received BGP UPDATE messages from peer                             | `peer`                                 |
| bgp_received_withdraw_prefix_total | Number of received BGP WITHDRAW-PREFIX messages from peer                    | `peer`                                 |
| bgp_received_withdraw_update_total | Number of received BGP WITHDRAW-UPDATE messages from peer                    | `peer`                                 |

## Label values

Some labels can have specific values depending on the state of GoBGP or of the peers:

- `peer`: the IP of the remote BGP peer
- `session_state`: the BGP FSM status of the peer, can be either `UNKNOWN`, `IDLE`, `CONNECT`, `IDLE`, `ACTIVE`, `OPENSENT`, `OPENCONFIRM` or `ESTABLISHED`
- `admin_state`: administrative state of the peer, can be either `DOWN`, `UP` or `PFX_CNT` if prefix limit is reached
- `route_family`: any address family supported by GoBGP (e.g `ipv4`, `ipv6`, `evpn`)

## Grafana dashboard

There is an example Grafana panel to display some metrics about GoBGP available [here](https://grafana.com/grafana/dashboards/22061-gobgp/)
